//================================================================================
//
//  This code is the intellectual property of Jerry Jongerius (duckware.com)
//
//================================================================================

import java.io.*;
import java.net.*;

public class Server implements Runnable {

    //----------------------------------------------------------------------
    public static void main( String args[] ) throws IOException {
        JavaSleepBugFix.ref();
        new Server().go(args);
        }

    //======================================================================
    //======================================================================
    //======================================================================

    private DatagramSocket m_ds;
    private InetSocketAddress m_to;   // punch through NAT to this ONE client

    //----------------------------------------------------------------------
    public void go( String args[] ) throws IOException {

        // arguments
        if (args.length<1) {
            System.out.println( "java Server CLIENT[:PORT]" );
            return;
            }
        System.out.println( "Press CTRL-C to exit this program" );

        int nAt=0;
        int nClientPort=0;
        String CLIENT = G.parseServerPort(args[nAt+0],nClientPort);
        m_to = new InetSocketAddress(InetAddress.getByName(CLIENT), G.getClientPort());

        // socket
        m_ds = new DatagramSocket(G.getServerPort());
        int r1 = m_ds.getReceiveBufferSize();
        m_ds.setReceiveBufferSize( 10*1024*1024 );
        int r2 = m_ds.getReceiveBufferSize();
        System.out.println( "SERVER: "+getExternalAddress()+":"+G.getServerPort()+" (buffer:"+r1+"->"+r2+")" );
        System.out.println( "Punch: "+ m_to );

        // start punch thread
        new Thread(this,"Server").start();

        runServer();
        }

    //----------------------------------------------------------------------
    // process packets from Clients
    private void runServer() throws IOException {

        // servicing packets received is time critical
        Thread.currentThread().setPriority(Thread.MAX_PRIORITY);

        byte buffer[] = new byte[65536];
        DatagramPacket packet = new DatagramPacket(buffer, buffer.length);

        while (true) {
            m_ds.receive(packet);
            int nBase=G.C_HSIZE;
            if ((packet.getLength()>nBase) && (G.C_KEY==G.get4(buffer,0))) {
                int nCommand=G.get4(buffer,4);
                ClientInfo ci = ClientInfo.get(packet, false);
                if ((G.C_START==nCommand) && (null==ci)) {
                    ci = ClientInfo.get(packet,true);
                    System.out.println( "+"+packet.getSocketAddress() );
                    ci.init();
                    }
                if (null!=ci) {
                    // test/measure
                    if (G.C_TEST==nCommand) {
                        ci.add( packet );
                        }
                    // RTT/start
                    else if ((G.C_RTT==nCommand) || (G.C_START==nCommand)) {
                        m_ds.send(packet);
                        }
                    // client wants report
                    else if (G.C_END==nCommand) {
                        sendMessageToClient( ci.getReport(), (InetSocketAddress)packet.getSocketAddress() );
                        ci.init();
                        }
                    }
                }
            }
        }
    //----------------------------------------------------------------------
    private String getExternalAddress() {
        String ip="unknown";
        try {
            URL base = new URL( "https://www.duckware.com/cgi-bin/ip.cgi" );
            URLConnection con = base.openConnection();
            con.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/64.0.3282.140 Safari/537.36" );
            DataInputStream dis = new DataInputStream(con.getInputStream());
            String line = dis.readLine();
            dis.close();
            if (line.startsWith("ip=")) {
                ip = line.substring(3);
                }
            }
        catch (IOException e) {
            e.printStackTrace();
            }
        return ip;
        }
    //----------------------------------------------------------------------
    private void sendMessageToClient( String msg, InetSocketAddress sa ) {
        try {
            byte[] buffer = G.makeBuffer( G.C_MSG, msg.length() );
            int nBase=G.C_HSIZE;
            msg.getBytes( 0, msg.length(), buffer, nBase );
            if (msg.length()>1) {
                String to = sa.getAddress().getHostAddress()+":"+sa.getPort();
                System.out.println( to+": "+msg );
                }
            m_ds.send( new DatagramPacket(buffer, buffer.length, sa) );
            }
        catch (IOException e) {
            e.printStackTrace();
            }
        }
    //----------------------------------------------------------------------
    // Punch through NAT for the ONE client specified on command line
    public void run() {
        while (true) {
            sendMessageToClient( ".", m_to );
            G.sleep(15000);
            }
        }
    }


