//================================================================================
//
//  This code is the intellectual property of Jerry Jongerius (duckware.com)
//
//================================================================================

// pulled from DuckwareLibraryCode

public class HighResolutionTimer {
    static { JavaSleepBugFix.ref(); }
    private long m_start;               // start nanoTime() tick

    //----------------------------------------------------------------------
    public HighResolutionTimer() {
        reset();
        }
    //----------------------------------------------------------------------
    public void reset() {
        m_start = G.nanoTime();
        }
    //----------------------------------------------------------------------
    // nanosecond timing
    public long ns() {
        return (G.nanoTime()-m_start);
        }
    //----------------------------------------------------------------------
    // microsecond timing
    public long us() {
        return ns()/1000;
        }
    //----------------------------------------------------------------------
    // millisecond timing
    public long ms() {
        return ns()/1000000;
        }

    //----------------------------------------------------------------------
    // almost always a fractional 'ms', so spinwait is only way to be accurate
    public void spinUntil( long nsEnd ) {

        // in 'high resolution time' mode, spin until exact time
        if (G.g_bHRT) {
            while (ns()<nsEnd) {
                }
            }

        // otherwise, get within one millisecond of correct time
        else {
            G.sleep( (nsEnd-ns()+999999)/1000000 );
            }
        }
    }
