//================================================================================
//
//  This code is the intellectual property of Jerry Jongerius (duckware.com)
//
//================================================================================

import java.util.*;

public class G {
    public static final int C_KEY=0x55445032;  // 'UDP2'
    public static final int C_START=100;
    public static final int C_MSG=101;
    public static final int C_TEST=102;
    public static final int C_RTT=103;
    public static final int C_END=199;
    public static final int C_HSIZE=16;
    private static int g_nServerPort=3000;
    private static int g_nClientPort=3001;
    public static boolean g_bHRT=true;         // extreme precision (via spin wait); otherwise to the millisecond

    //----------------------------------------------------------------------
    public static String parseServerPort( String sp, int nClientPort ) {
        int nC = sp.indexOf(":");
        if (nC>0) {
            setPorts( Integer.parseInt(sp.substring(nC+1)), nClientPort );
            sp = sp.substring(0,nC);
            }
        return sp;
        }
    //----------------------------------------------------------------------
    private static void setPorts( int nServerPort, int nClientPort ) {
        g_nServerPort = nServerPort;
        g_nClientPort = (0==nClientPort) ? nServerPort+1 : 0;
        }
    //----------------------------------------------------------------------
    public static int getServerPort() {
        return g_nServerPort;
        }
    //----------------------------------------------------------------------
    public static int getClientPort() {
        return g_nClientPort;
        }



    //----------------------------------------------------------------------
    public static long nanoTime() {
        return System.nanoTime();
        }
    //----------------------------------------------------------------------
    // returns *tenths* of ms
    public static long tick() {
        return nanoTime()/100000;
        }

    //----------------------------------------------------------------------
    public static long alignWait( int nAlign ) {
        if (nAlign>0) {
            long tEnd = (System.currentTimeMillis()+nAlign-1)/nAlign*nAlign;
            while (System.currentTimeMillis()<tEnd) {
                sleep(1);
                }
            }
        return System.currentTimeMillis();
        }

    //----------------------------------------------------------------------
    public static void sleep( long ms ) {
        if (ms>0) {
            try { Thread.sleep(ms); } catch (InterruptedException e) {}
            }
        }

    //----------------------------------------------------------------------
    public static void put4( byte[] buffer, int offset, int value ) {
        for (int loop=3; loop>=0; --loop) {
            buffer[offset+loop] = (byte)value;
            value >>>= 8;
            }
        }
    //----------------------------------------------------------------------
    public static int get4( byte[] buffer, int offset ) {
        int ret = 0;
        for (int loop=0; loop<4; ++loop) {
            ret <<= 8;
            ret |= 0xFF&buffer[offset+loop];
            }
        return ret;
        }
    //----------------------------------------------------------------------
    public static String ttt( long lTime ) {
        Date d = new Date(lTime);
        return (d.getYear()+1900)+"/"+n2(1+d.getMonth())+"/"+n2(d.getDate())+" "+n2(d.getHours())+":"+n2(d.getMinutes())+":"+n2(d.getSeconds())+"."+n3((int)(lTime%1000));
        }
    //----------------------------------------------------------------------
    public static String n2( int n ) {
        return ""+((n/10)%10)+((n/1)%10);
        }
    //----------------------------------------------------------------------
    public static String n3( int n ) {
        return ""+((n/100)%10)+((n/10)%10)+((n/1)%10);
        }
    //----------------------------------------------------------------------
    public static byte[] makeBuffer( int type, int len ) {
        byte buffer[] = new byte[C_HSIZE+len];
        G.put4( buffer, 0, C_KEY );
        G.put4( buffer, 4, type );
        return buffer;
        }
    //----------------------------------------------------------------------
    public static String d2( double d ) {
        return String.format("%.2f",d);
        }
    //----------------------------------------------------------------------
    public static String d1( double d ) {
        return String.format("%.1f",d);
        }
    }
