//================================================================================
//
//  This code is the intellectual property of Jerry Jongerius (duckware.com)
//
//================================================================================

import java.io.*;
import java.net.*;
import java.util.*;

public class ClientInfo {
    private static Hashtable<String,ClientInfo> g_ht = new Hashtable<String,ClientInfo>();

    //----------------------------------------------------------------------
    // by design, as test code, only holds a couple of clients (so we don't remove)
    public static ClientInfo get( DatagramPacket packet, boolean bCreate ) {
        InetSocketAddress sa = (InetSocketAddress)packet.getSocketAddress();
        String key = sa.getAddress().getHostAddress()+"-"+sa.getPort();
        ClientInfo ret = g_ht.get(key);
        if (bCreate && (null==ret)) {
            ret = new ClientInfo();
            g_ht.put( key, ret );
            }
        return ret;
        }

    //======================================================================
    //======================================================================
    //======================================================================

    public int m_nNumBytes;
    public int m_nNumPackets;
    public long m_tFirst;
    public long m_tLast;

    //----------------------------------------------------------------------
    public ClientInfo() {
        init();
        }
    //----------------------------------------------------------------------
    public void init() {
        m_nNumBytes = 0;
        m_nNumPackets = 0;
        m_tFirst = 0;
        m_tLast = 0;
        }
    //----------------------------------------------------------------------
    public void add( DatagramPacket packet ) {
        long tNow = G.tick();
        if ((tNow-m_tLast)>10000*10) {  // steady stream makes a session (10s timeout)
            init();
            }
        m_tFirst = (0==m_tFirst)?tNow:m_tFirst;
        m_tLast = tNow;
        m_nNumBytes += packet.getLength();
        m_nNumPackets += 1;
        }
    //----------------------------------------------------------------------
    public String getReport() {
        long tDelta = Math.max(1,m_tLast-m_tFirst);
        int bps = (int)(m_nNumBytes*8000.0/(tDelta/10.0));
        String mbps = G.d2(bps/1000000.0);
        String msg = "Recv: "+m_nNumPackets+" packets ("+m_nNumBytes+" bytes) in "+(tDelta/10.0)+"ms ("+mbps+" Mbps)";
        init();
        return msg;
        }
    }

