//================================================================================
//
//  This code is the intellectual property of Jerry Jongerius (duckware.com)
//
//================================================================================

import java.io.*;
import java.net.*;
import java.util.*;

public class Client implements Runnable {

    //----------------------------------------------------------------------
    public static void main( String args[] ) throws IOException {
        JavaSleepBugFix.ref();
        new Client().go(args);
        }

    //======================================================================
    //======================================================================
    //======================================================================

    private int LEN=1000;
    private DatagramSocket m_ds;
    private InetSocketAddress m_to;
    private long[] m_rtt = new long[3];
    private int m_nNumRTT=0;
    private int m_nNumMessages=0;
    private boolean m_bCanStart=false;

    //----------------------------------------------------------------------
    // process responses from Server
    public void run() {
        while (true) {
            try {
                byte buffer[] = new byte[200];
                DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
                m_ds.receive(packet);
                int nBase=G.C_HSIZE;
                if ((packet.getLength()>nBase) && (G.C_KEY==G.get4(buffer,0))) {
                    int nCommand=G.get4(buffer,4);
                    if (G.C_RTT==nCommand) {
                        m_rtt[m_nNumRTT++] = (int)G.tick()-G.get4(buffer,nBase);
                        }
                    else if (G.C_MSG==nCommand) {
                        String s = new String(packet.getData(), nBase, packet.getLength()-nBase);
                        if (s.length()>10) {
                            ++m_nNumMessages;
                            System.out.println( s );
                            }
                        }
                    else if (G.C_START==nCommand) {
                        m_bCanStart = true;
                        }
                    }
                }
            catch (IOException e) {
                System.out.println( ""+e );
                G.sleep(100);
                }
            }
        }

    //----------------------------------------------------------------------
    private void go( String args[] ) throws IOException {
        int nClientPort = 0;     // client is running on this local port (0=any)

        boolean bAlign=false;
        int nAt=0;
        while (nAt<args.length && args[nAt].startsWith("-")) {
            if ("-align".equals(args[nAt])) {
                bAlign = true;
                }
            else if ("-1ms".equals(args[nAt])) {
                G.g_bHRT = false;
                }
            else if (args[nAt].startsWith("-l:")) {
                int n = Integer.parseInt(args[nAt].substring(3));
                LEN = n>=10 && n<=10000 ? n : 1000;
                }
            else if (args[nAt].startsWith("-port:")) {
                nClientPort = Integer.parseInt(args[nAt].substring(6));
                }
            else {
                System.out.println( "UNKNOWN ARG: "+args[nAt] );
                }
            ++nAt;
            }

        String SERVER = null;
        int L1 = 0;
        long W1 = 0;
        int L2 = 0;
        long W2 = 0;
        int nRepeat = 1;

        // 'server:port' is mandatory
        if (nAt+1<=args.length) {
            SERVER = G.parseServerPort(args[nAt+0], nClientPort);
            nAt += 1;
            }
        // First '# packets over time' mandatory
        if (nAt+2<=args.length) {
            L1 = Integer.parseInt( args[nAt+0] );
            W1 = (long)(Double.parseDouble(args[nAt+1])*1000000);
            nAt += 2;
            }
        // Second '# packet over time' is optional (default: none)
        if (nAt+2<=args.length) {
            L2 = Integer.parseInt( args[nAt+0] );
            W2 = (long)(Double.parseDouble(args[nAt+1])*1000000);
            nAt += 2;
            }
        // Final 'repeat #' is optional (default 1)
        if (nAt+1<=args.length) {
            nRepeat = Integer.parseInt(args[nAt+0]);
            nAt += 1;
            }

        // if mandatory arguments were present, continue
        if (null!=SERVER && L1>0) {
            // UDP socket / set egress buffer size
            m_ds = new DatagramSocket(G.getClientPort());
            int r1 = m_ds.getSendBufferSize();
            m_ds.setSendBufferSize( 10*1024*1024 );
            int r2 = m_ds.getSendBufferSize();
            System.out.println( "Listening on local port: "+m_ds.getLocalPort() );

            //
            m_to = new InetSocketAddress( InetAddress.getByName(SERVER), G.getServerPort() );
            System.out.println( "Server: "+m_to );

            //
            new Thread(this,"Client").start();
            G.sleep(100);

            //
            sendStart();
            G.sleep(100);
            sendStart();
            G.sleep(100);
            if (m_bCanStart) {
                runClient(bAlign,L1,W1,L2,W2,nRepeat);
                }
            else {
                System.out.println( "ERROR: Missing startup handshake (is server running?)" );
                }
            }

        // otherwise display help message
        else {
            System.out.println( "USAGE: java Client [-align] [-l:#] [-1ms] [-port:#] SERVER[:PORT] num-packets over-ms [num-packets over-ms [repeat#]]" );
            }

        System.exit(0);
        }

    //----------------------------------------------------------------------
    private byte[] makePacketBuffer() {
        int nBase = G.C_HSIZE;
        byte buffer[] = G.makeBuffer( G.C_TEST, LEN-nBase );
        for (int loop=nBase; loop<buffer.length; ++loop) {
            buffer[loop] = (byte)('a'+(loop-nBase)%26);
            }
        return buffer;
        }

    //----------------------------------------------------------------------
    // run Client UDP test
    private void runClient( boolean bAlign, int L1, long W1, int L2, long W2, int nRepeat ) throws IOException {
        byte buffer[] = makePacketBuffer();
        DatagramPacket out = new DatagramPacket(buffer, buffer.length, m_to);
        HighResolutionTimer hrt = new HighResolutionTimer();

        sendRTT();
        G.sleep(100);
        sendRTT();
        G.sleep(100);

        System.out.println( "Sending: "+L1+" packets over "+G.d1(W1/1000000)+"ms, and "+L2+" packets over "+G.d1(W2/1000000)+"ms ["+nRepeat+" times]" );

        int nNumPackets=0;
        int nAlign = bAlign?5000:0;
        long tStart = G.alignWait(nAlign);
        System.out.println( "Time: "+G.ttt(tStart)+(nAlign>0?" (align="+nAlign+"ms)":"") );

        // try to align to system 'sleep' capabilities
        G.sleep(1);  
        long t1 = hrt.ns();


        // send square-wave of packets out
        long ton = t1;
        for (int loop=0; loop<nRepeat; ++loop) {

            // first num-packets over time
            for (int l1=0; l1<L1; ++l1) {
                m_ds.send(out);
                ++nNumPackets;
                hrt.spinUntil(ton+(l1+1)*W1/L1);
                }
            ton += W1;
            hrt.spinUntil(ton);

            // optional: second num-packets over time
            if (W2>0) {
                for (int l2=0; l2<L2; ++l2) {
                    m_ds.send(out);
                    ++nNumPackets;
                    hrt.spinUntil(ton+(l2+1)*W2/L2);
                    }
                ton += W2;
                hrt.spinUntil(ton);
                }
            }

        long t2 = hrt.ns();
        sendRTT();

        if (true) {
            double ms = (t2-t1)/1000000.0;
            int nBytes = nNumPackets*buffer.length;
            long bps = (long)(nBytes*8000.0/ms);
            String mbps = G.d2(bps/1000000.0);
            System.out.println( "Sent: "+nNumPackets+" packets ("+nBytes+" bytes) in "+G.d1(ms)+"ms ("+mbps+" Mbps)" );
            }

        //
        G.sleep(200);
        askForReport();
        G.sleep(500);

        System.out.println( "RTT: "+ (m_rtt[0]/10.0)+", "+(m_rtt[1]/10.0) + " -> " + (m_rtt[2]/10.0) );
        }

    //----------------------------------------------------------------------
    private void sendStart( ) throws IOException {
        byte buffer[] = G.makeBuffer(G.C_START, 16);
        DatagramPacket out = new DatagramPacket(buffer, buffer.length, m_to);
        m_ds.send(out);
        }
    //----------------------------------------------------------------------
    private void sendRTT( ) throws IOException {
        byte buffer[] = G.makeBuffer(G.C_RTT, 16);
        int nBase = G.C_HSIZE;
        G.put4( buffer, nBase+0, (int)G.tick() );
        DatagramPacket out = new DatagramPacket(buffer, buffer.length, m_to);
        m_ds.send(out);
        }
    //----------------------------------------------------------------------
    private void askForReport( ) throws IOException {
        byte buffer[] = G.makeBuffer(G.C_END, 16);
        DatagramPacket out = new DatagramPacket(buffer, buffer.length, m_to);
        m_ds.send(out);
        }
    }
