/*
 * Decompiled with CFR 0.152.
 */
import java.net.DatagramPacket;
import java.net.InetSocketAddress;
import java.util.Hashtable;

public class ClientInfo {
    private static Hashtable<String, ClientInfo> g_ht = new Hashtable();
    public int m_nNumBytes;
    public int m_nNumPackets;
    public long m_tFirst;
    public long m_tLast;

    public static ClientInfo get(DatagramPacket datagramPacket, boolean bl) {
        InetSocketAddress inetSocketAddress = (InetSocketAddress)datagramPacket.getSocketAddress();
        String string = inetSocketAddress.getAddress().getHostAddress() + "-" + inetSocketAddress.getPort();
        ClientInfo clientInfo = g_ht.get(string);
        if (bl && null == clientInfo) {
            clientInfo = new ClientInfo();
            g_ht.put(string, clientInfo);
        }
        return clientInfo;
    }

    public ClientInfo() {
        this.init();
    }

    public void init() {
        this.m_nNumBytes = 0;
        this.m_nNumPackets = 0;
        this.m_tFirst = 0L;
        this.m_tLast = 0L;
    }

    public void add(DatagramPacket datagramPacket) {
        long l = G.tick();
        if (l - this.m_tLast > 100000L) {
            this.init();
        }
        this.m_tFirst = 0L == this.m_tFirst ? l : this.m_tFirst;
        this.m_tLast = l;
        this.m_nNumBytes += datagramPacket.getLength();
        ++this.m_nNumPackets;
    }

    public String getReport() {
        long l = Math.max(1L, this.m_tLast - this.m_tFirst);
        int n = (int)((double)this.m_nNumBytes * 8000.0 / ((double)l / 10.0));
        String string = G.d2((double)n / 1000000.0);
        String string2 = "Recv: " + this.m_nNumPackets + " packets (" + this.m_nNumBytes + " bytes) in " + (double)l / 10.0 + "ms (" + string + " Mbps)";
        this.init();
        return string2;
    }
}

