//================================================================================
//
//  This code is the intellectual property of Jerry Jongerius (duckware.com)
//
//================================================================================

//
// pulled from DuckwareLibraryCode
//

import java.awt.*;

public class DoubleBuffer {
    private static Lock g_lock = new Lock();    // lock so that only a single paint is ongoing at once
    private static Component g_owner=null;      // owner of smooth paint double buffer image
    private static Image g_image;               // double buffer image

    //----------------------------------------------------------------------
    private DoubleBuffer() {
        }
    //----------------------------------------------------------------------
    private static Rectangle compRectParentClipped( Component comp ) {
        Point loc = comp.getLocation();
        Dimension d = comp.getSize();
        Rectangle r1 = new Rectangle(0,0,d.width,d.height);
        Rectangle r2 = new Rectangle(new Point(-loc.x,-loc.y), comp.getParent().getSize());
        return r1.intersection(r2);
        }
    //----------------------------------------------------------------------
    public static boolean go( Component comp, Graphics g1 ) {
        boolean bGrabbedOwnership=false;
        // at all costs, avoid deadlock, so if after a certain small amount of time
        // if ownwership of the double buffer can not be obtained, we simply allow
        // the component to be painted NON-smoothly.
        synchronized(g_lock) {
            // comp is owner of smooth updatecomponent is owner of smooth update and can paint immediately
            if (comp==g_owner) {
                return true;
                }
            // if there is a current owner, wait for owner to exit
            if (g_owner!=null) {
                G.wait(g_lock,333);
                }

            // try to become owner
            if (g_owner==null) {
                g_owner = comp;
                bGrabbedOwnership = true;
                }
            }

        // if comp is NOT owner of double buffer, paint NON-smoothly
        // not great, but better than hanging
        if (!bGrabbedOwnership) {
            Dimension d = comp.getSize();
            g1.setColor( comp.getBackground() );
            g1.fillRect( 0, 0, d.width, d.height );
            g1.setColor( comp.getForeground() );
            return true;
            }

        // otherwise, comp IS the owner of the smooth update buffer -- so smooth paint
        try {
            Image img = g_image;
            Rectangle r1 = g1.getClipBounds();
            Rectangle r2 = compRectParentClipped(comp);
            Rectangle clip = (r1!=null) ? r1.intersection(r2) : r2;
            int x = clip.x;
            int y = clip.y;
            int w = Math.max(1,clip.width);
            int h = Math.max(1,clip.height);
            int iw = (img!=null) ? img.getWidth(null) : 0;
            int ih = (img!=null) ? img.getHeight(null) : 0;
            if ((img==null) || (w>iw) || (h>ih)) {
                img = comp.createImage(Math.max(w,iw), Math.max(h,ih));
                g_image = img;
                }
            Graphics g = img.getGraphics();
            g.setFont( g1.getFont() );
            g.setClip( 0, 0, w, h );
            g.translate( -x, -y );
            g.setColor( comp.getBackground() );
            g.fillRect( x, y, w, h );
            g.setColor( g1.getColor() );
            comp.paint( g );                // NOTE: recursive back to us
            g.dispose();
            g1.drawImage( img, x, y, x+w, y+h, 0, 0, w, h, null );
            }
        catch (Exception e) {
            e.printStackTrace();
            g_image = null;
            g1.setColor( Color.red );
            g1.drawString( e.toString(), 2, g1.getFontMetrics().getHeight() );
            }
        finally {
            synchronized(g_lock) {
                g_owner = null;
                G.notify(g_lock);
                }
            }
        return false;
        }
    }
