/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Panel;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;

public class txrate
extends Panel {
    private static long g_tBoot = System.nanoTime();
    private AppFrame m_app;
    private int g_nDebugLevel = 0;
    private static final int MSRUN = 20;
    private static final int MSSLOT = 50;
    private DatagramChannel m_s;
    private ByteBuffer m_buffer;
    private long m_tRunStart = 0L;
    private long m_tRunEnd = 0L;
    private long m_tLastWrite = 0L;
    private long m_tLastWriteWorked = 0L;
    private long m_lMaxStall = 0L;
    private int m_nNumStalls = 0;
    private long m_tPushing = 0L;
    private int m_nScaleInclude = 10;
    private long m_tGraphStart = 0L;
    private long m_onbucket;
    private int m_accum;
    private long[] m_alSent;
    private int m_nAt;
    private long m_nPaintBucket = 0L;
    int[] SS = new int[]{10, 20, 30, 40, 50, 75, 100, 150, 200, 250, 300, 400, 500, 600, 750, 1000, 2000};
    private String m_info = "";

    private static long tick() {
        return System.nanoTime() - g_tBoot;
    }

    private static long ms2t(int n) {
        return (long)n * 1000000L;
    }

    private static double dms(long l) {
        return (double)(l / 100000L) / 10.0;
    }

    private static String tos(int[] nArray) {
        String string = "";
        for (int i = 0; i < nArray.length; ++i) {
            string = string + (i > 0 ? " " : "") + nArray[i];
        }
        return string;
    }

    private static int imax(int[] nArray) {
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] < nArray[n]) continue;
            n = i;
        }
        return n;
    }

    private static long amax(long[] lArray) {
        long l = 0L;
        for (int i = 0; i < lArray.length; ++i) {
            l = Math.max(l, lArray[i]);
        }
        return l;
    }

    private static double amax(double[] dArray) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d = Math.max(d, dArray[i]);
        }
        return d;
    }

    private static long asum(long[] lArray) {
        long l = 0L;
        for (int i = 0; i < lArray.length; ++i) {
            l += lArray[i];
        }
        return l;
    }

    private static String getProperty(String string) {
        return System.getProperty(string);
    }

    private static double d1(double d) {
        return Math.floor(d * 10.0) / 10.0;
    }

    private static double per(double d) {
        return txrate.d1(100.0 * d);
    }

    public static void main(String[] stringArray) {
        try {
            new txrate().go(stringArray);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        System.exit(0);
    }

    private void go(String[] stringArray) throws IOException {
        String string = null;
        int n = 21065;
        int n2 = 1400;
        int n3 = 2000;
        int n4 = 262144;
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (string2.startsWith("-l:")) {
                n2 = Integer.parseInt(string2.substring(3));
                continue;
            }
            if (string2.startsWith("-ms:")) {
                n3 = Integer.parseInt(string2.substring(4));
                continue;
            }
            if (string2.startsWith("-port:")) {
                n = Integer.parseInt(string2.substring(6));
                continue;
            }
            if (string2.startsWith("-debug:")) {
                this.g_nDebugLevel = Integer.parseInt(string2.substring(7));
                continue;
            }
            if (string2.startsWith("-sndbuf:")) {
                n4 = Integer.parseInt(string2.substring(8));
                continue;
            }
            if (string2.startsWith("-scale:")) {
                this.m_nScaleInclude = Integer.parseInt(string2.substring(7));
                continue;
            }
            if (string2.equals("-live")) {
                bl = true;
                continue;
            }
            if (string2.startsWith("-")) {
                System.out.println("??? " + string2);
                continue;
            }
            if (null != string) continue;
            string = string2;
        }
        if (null == string) {
            System.out.println("Duckware (R) txrate (TM) Version 4.1a");
            System.out.println("Copyright (c) 2006-2023 Duckware. All rights reserved.");
            System.out.println("Java " + txrate.getProperty("java.vendor") + " " + txrate.getProperty("java.version") + " [" + txrate.getProperty("java.home") + "]");
            System.out.println("");
            System.out.println("txrate [-l:size] [-port:#] [-ms:#] [-debug:#] [-sndbuf:#] [-live] HOST");
            System.out.println("");
            System.out.println("    HOST: ip address of the local gateway");
            System.out.println("");
            System.out.println("  Options:");
            System.out.println("    -l:size    size of packets to send (default: 1400)");
            System.out.println("    -port:#    send packets to this UDP port (default: 21065)");
            System.out.println("    -ms:#      duration of test in milliseconds (default: 2000)");
            System.out.println("    -debug:#   set debug level 2|1 (default: 0, or off)");
            System.out.println("    -sndbuf:#  socket SO_SNDBUF value (default: 262144)");
            System.out.println("    -scale:#   include this mbps value in scale calculations");
            System.out.println("    -live      displays a real-time chart");
        } else {
            this.m_app = new AppFrame(this);
            if (bl) {
                this.m_app.show();
            }
            this.run(n4, string, n, n2, n3);
            while (this.m_app.isShowing()) {
                G.sleep(200L);
            }
        }
    }

    private int doWritePacket(boolean bl) throws IOException {
        this.m_buffer.rewind();
        int n = this.m_s.write(this.m_buffer);
        long l = txrate.tick();
        long l2 = l - this.m_tLastWrite;
        if (this.g_nDebugLevel >= 2) {
            System.out.println(l + "\t" + l2 + "\t" + n);
        }
        this.m_tLastWrite = l;
        if (n > 0) {
            this.m_lMaxStall = Math.max(this.m_lMaxStall, bl ? l - this.m_tLastWriteWorked : 0L);
            this.m_tLastWriteWorked = l;
        } else {
            this.m_tPushing += l2;
        }
        return n;
    }

    private int doWriteRun(boolean bl) throws IOException {
        int n = 0;
        this.m_tRunStart = this.m_tRunEnd;
        long l = 0L;
        long l2 = txrate.tick();
        long l3 = this.m_tLastWrite;
        boolean bl2 = false;
        while (txrate.tick() - Math.max(l2, l) < txrate.ms2t(20)) {
            l3 = this.m_tLastWrite;
            int n2 = this.doWritePacket(bl);
            if (l > 0L && 0 == n2) {
                bl2 = true;
                break;
            }
            n += n2;
            if (0L != l || n2 <= 0) continue;
            l = this.m_tLastWrite;
        }
        this.m_tRunEnd = l3;
        long l4 = this.m_tRunEnd - this.m_tRunStart;
        if (bl2) {
            // empty if block
        }
        if (this.g_nDebugLevel >= 1) {
            System.out.println("*** [" + this.m_tRunStart + "-" + this.m_tRunEnd + "] " + n + " in " + (double)l4 / 1000000.0);
        }
        if (bl && this.calcmbps(n, l4) > 5000.0 && l4 > txrate.ms2t(2)) {
            System.out.println("ERR: " + n + " in " + (double)l4 / 1000000.0 + " is too fast - filtered out");
            n = 0;
        }
        if (0 == n && bl) {
            ++this.m_nNumStalls;
        }
        return n;
    }

    private int[] makeShape(long[] lArray) {
        int[] nArray = new int[lArray.length];
        long l = txrate.amax(lArray);
        if (l > 0L) {
            for (int i = 0; i < lArray.length; ++i) {
                nArray[i] = (int)(100.0 * (double)lArray[i] / (double)l);
            }
        }
        return nArray;
    }

    private double calcContention(long[] lArray) {
        long l = Math.max(1L, txrate.amax(lArray) * (long)lArray.length);
        return (double)(l - txrate.asum(lArray)) / (double)l;
    }

    private double calcStalled(int n) {
        return (double)this.m_nNumStalls / (double)((n + 20 - 1) / 20);
    }

    private double calcmbps(long l, long l2) {
        return l2 > 0L ? 8.0 * (double)l / 1000000.0 / ((double)l2 / 1.0E9) : 0.0;
    }

    public byte[] createPacket(int n) {
        byte[] byArray = new byte[n];
        String string = "** network interface Tx speed test **";
        int n2 = string.length();
        for (int i = 0; i < byArray.length; i += n2) {
            string.getBytes(0, Math.min(n2, byArray.length - i), byArray, i);
        }
        return byArray;
    }

    private int getSendBufferSize() throws IOException {
        return this.m_s.getOption(StandardSocketOptions.SO_SNDBUF);
    }

    private void doSetupSocket(int n, InetSocketAddress inetSocketAddress, int n2) throws IOException {
        this.m_s = DatagramChannel.open();
        this.m_s.configureBlocking(false);
        if (this.g_nDebugLevel >= 1) {
            System.out.println("default SO_SNDBUF: " + this.getSendBufferSize());
        }
        this.m_s.setOption((SocketOption)StandardSocketOptions.SO_SNDBUF, (Object)n);
        this.m_s.bind(null);
        this.m_s.connect(inetSocketAddress);
        this.m_buffer = ByteBuffer.wrap(this.createPacket(n2));
    }

    private long doStartup(int n) throws IOException {
        long l;
        this.m_tLastWrite = l = txrate.tick();
        this.m_tRunEnd = l;
        long l2 = l;
        int n2 = 0;
        for (int i = 0; i < 3 || txrate.tick() - l2 < txrate.ms2t(100) || n2 < n; n2 += this.doWriteRun(false), ++i) {
        }
        long l3 = txrate.tick() - l2;
        if (this.g_nDebugLevel >= 1) {
            System.out.println("startup in " + txrate.dms(l3));
        }
        this.m_tPushing = 0L;
        return l3;
    }

    private void run(int n, String string, int n2, int n3, int n4) throws IOException {
        long l;
        System.out.println("Running...");
        Thread thread = Thread.currentThread();
        thread.setPriority(10);
        long l2 = 0L;
        long[] lArray = new long[n4 / 50];
        this.doSetupSocket(n, new InetSocketAddress(string, n2), n3);
        long l3 = this.doStartup(n);
        this.m_tGraphStart = this.m_tRunEnd;
        long l4 = l = this.m_tRunEnd;
        int n5 = 0;
        while (l4 - l < txrate.ms2t(n4)) {
            int n6 = this.doWriteRun(true);
            if (n6 > 0) {
                this.addSent(lArray, n6, l4 - l, this.m_tRunEnd - l, 50);
                l2 += (long)n6;
            }
            this.setHaveLiveBytes(n6, lArray, (int)((this.m_tRunEnd - l) / txrate.ms2t(50)));
            l4 = this.m_tRunEnd;
            ++n5;
        }
        long l5 = l4 - l;
        double d = this.calcmbps(l2, l5);
        this.setHaveResult(d);
        this.doRepaint(true);
        thread.setPriority(5);
        String string2 = "=";
        System.out.println("ipTarget" + string2 + string);
        System.out.println("nPort" + string2 + n2);
        System.out.println("SO_SNDBUF" + string2 + this.getSendBufferSize());
        System.out.println("nPacketSize" + string2 + n3);
        System.out.println("msStartup" + string2 + txrate.dms(l3));
        System.out.println("msDuration" + string2 + txrate.dms(l5));
        System.out.println("msPushing" + string2 + txrate.dms(this.m_tPushing));
        System.out.println("nBytesSent" + string2 + l2);
        System.out.println("txshape" + string2 + txrate.tos(this.makeShape(lArray)));
        System.out.println("msMaxStall" + string2 + txrate.dms(this.m_lMaxStall));
        System.out.println("pStalled" + string2 + txrate.per(this.calcStalled(n4)));
        System.out.println("pContention" + string2 + txrate.per(this.calcContention(lArray)));
        System.out.println("txrate" + string2 + txrate.d1(d));
        this.m_s.close();
    }

    private void addSent(long[] lArray, int n, long l, long l2, int n2) {
        if (l2 > l) {
            long l3 = txrate.ms2t(n2);
            int n3 = (int)(l / l3);
            int n4 = (int)(l2 / l3);
            for (int i = n3; i <= n4; ++i) {
                long l4;
                long l5;
                if (i < 0 || i >= lArray.length || (l5 = Math.max((long)(i + 0) * l3, l)) >= (l4 = Math.min((long)(i + 1) * l3, l2))) continue;
                int n5 = i;
                lArray[n5] = lArray[n5] + (long)((double)(l4 - l5) / (double)(l2 - l) * (double)n);
            }
        }
    }

    private void doRepaint(boolean bl) {
        long l = txrate.tick() / txrate.ms2t(16);
        if (bl || l != this.m_nPaintBucket) {
            this.m_nPaintBucket = l;
            this.repaint();
        }
    }

    private int mapScale(double d) {
        for (int i = 0; i < this.SS.length; ++i) {
            if (!(d < (double)this.SS[i])) continue;
            return this.SS[i];
        }
        return (int)d;
    }

    private void setHaveLiveBytes(int n, long[] lArray, int n2) {
        this.m_alSent = lArray;
        this.m_nAt = n2;
        long l = txrate.ms2t(500);
        long l2 = (txrate.tick() - this.m_tGraphStart) / l;
        if (l2 != this.m_onbucket) {
            this.m_onbucket = l2;
            this.setHaveResult(this.calcmbps(this.m_accum, l));
            this.m_accum = 0;
        }
        this.m_accum += n;
        this.doRepaint(false);
    }

    private void setHaveResult(double d) {
        this.setInfo("TxRate: " + txrate.d1(d) + " Mbps");
        this.doRepaint(false);
    }

    private void setInfo(String string) {
        this.m_info = string;
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    @Override
    public void paint(Graphics graphics) {
        if (DoubleBuffer.go(this, graphics)) {
            this.paint2(graphics);
        }
    }

    private void paint2(Graphics graphics) {
        int n = 10;
        int n2 = 10;
        Dimension dimension = this.size();
        graphics.setColor(new Color(0xF0F0F0));
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        graphics.setFont(new Font("Arial", 1, 20));
        Object object = graphics.getFontMetrics();
        graphics.setColor(Color.BLUE);
        graphics.drawString("" + this.m_info, n, n2 += ((FontMetrics)object).getAscent());
        n2 += 8;
        if (null != this.m_alSent) {
            int n3;
            int n4;
            graphics.setFont(new Font("Arial", 0, 12));
            object = new double[Math.min(this.m_nAt, this.m_alSent.length)];
            for (n4 = 0; n4 < ((Object)object).length; ++n4) {
                object[n4] = txrate.d1(this.calcmbps(this.m_alSent[n4], txrate.ms2t(50)));
            }
            n4 = this.mapScale(Math.max((double)this.m_nScaleInclude, txrate.amax((double[])object)));
            int n5 = 10;
            int n6 = dimension.width - 2 * n5;
            int n7 = dimension.height - n2 - 2 * n5 - 20;
            int n8 = this.m_alSent.length - 1;
            graphics.setColor(Color.WHITE);
            graphics.fillRect(n5, dimension.height - n5 - n7, n6, n7);
            for (n3 = 0; n3 < 10; ++n3) {
                int n9 = dimension.height - n5 - n3 * n7 / 10;
                graphics.setColor(new Color(0xE0E0E0));
                graphics.drawLine(n5, n9, n5 + n6, n9);
                graphics.setColor(Color.BLACK);
                graphics.drawString("" + n4 * n3 / 10, n5 + 4, n9 - 2);
            }
            if (this.m_nAt > 0 && this.m_nAt < this.m_alSent.length) {
                graphics.setColor(Color.BLUE);
                n3 = n5 + n6 * (this.m_nAt - 1) / n8;
                graphics.drawLine(n3, dimension.height - n5, n3, dimension.height - n5 - n7);
            }
            graphics.setColor(Color.BLUE);
            int[] nArray = new int[((Object)object).length];
            int[] nArray2 = new int[((Object)object).length];
            if (n4 > 0) {
                graphics.setFont(new Font("Arial", 0, 12));
                graphics.setColor(Color.BLACK);
                graphics.drawString("Mbps", n5, dimension.height - n5 - n7 - 2);
                for (int i = 0; i < nArray.length; ++i) {
                    nArray[i] = n5 + n6 * i / n8;
                    nArray2[i] = dimension.height - n5 - (int)((double)n7 * object[i] / (double)n4);
                }
            }
            graphics.drawPolyline(nArray, nArray2, nArray.length);
            graphics.setColor(Color.BLACK);
            graphics.drawRect(n5, dimension.height - n5 - n7, n6, n7);
        }
    }
}

