/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;

public class DoubleBuffer {
    private static Lock g_lock = new Lock();
    private static Component g_owner = null;
    private static Image g_image;

    private DoubleBuffer() {
    }

    private static Rectangle compRectParentClipped(Component component) {
        Point point = component.getLocation();
        Dimension dimension = component.getSize();
        Rectangle rectangle = new Rectangle(0, 0, dimension.width, dimension.height);
        Rectangle rectangle2 = new Rectangle(new Point(-point.x, -point.y), component.getParent().getSize());
        return rectangle.intersection(rectangle2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean go(Component component, Graphics graphics) {
        boolean bl = false;
        Object object = g_lock;
        synchronized (object) {
            if (component == g_owner) {
                return true;
            }
            if (g_owner != null) {
                G.wait(g_lock, 333L);
            }
            if (g_owner == null) {
                g_owner = component;
                bl = true;
            }
        }
        if (!bl) {
            object = component.getSize();
            graphics.setColor(component.getBackground());
            graphics.fillRect(0, 0, ((Dimension)object).width, ((Dimension)object).height);
            graphics.setColor(component.getForeground());
            return true;
        }
        try {
            int n;
            object = g_image;
            Rectangle rectangle = graphics.getClipBounds();
            Rectangle rectangle2 = DoubleBuffer.compRectParentClipped(component);
            Rectangle rectangle3 = rectangle != null ? rectangle.intersection(rectangle2) : rectangle2;
            int n2 = rectangle3.x;
            int n3 = rectangle3.y;
            int n4 = Math.max(1, rectangle3.width);
            int n5 = Math.max(1, rectangle3.height);
            int n6 = object != null ? ((Image)object).getWidth(null) : 0;
            int n7 = n = object != null ? ((Image)object).getHeight(null) : 0;
            if (object == null || n4 > n6 || n5 > n) {
                g_image = object = component.createImage(Math.max(n4, n6), Math.max(n5, n));
            }
            Graphics graphics2 = ((Image)object).getGraphics();
            graphics2.setFont(graphics.getFont());
            graphics2.setClip(0, 0, n4, n5);
            graphics2.translate(-n2, -n3);
            graphics2.setColor(component.getBackground());
            graphics2.fillRect(n2, n3, n4, n5);
            graphics2.setColor(graphics.getColor());
            component.paint(graphics2);
            graphics2.dispose();
            graphics.drawImage((Image)object, n2, n3, n2 + n4, n3 + n5, 0, 0, n4, n5, null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            g_image = null;
            graphics.setColor(Color.red);
            graphics.drawString(exception.toString(), 2, graphics.getFontMetrics().getHeight());
        }
        finally {
            Lock lock = g_lock;
            synchronized (lock) {
                g_owner = null;
                G.notify(g_lock);
            }
        }
        return false;
    }
}

